/*
 * Decompiled with CFR 0.152.
 */
package net.endil.farmersutils.integration;

import com.google.common.base.Preconditions;
import mezz.jei.api.gui.handlers.IGuiProperties;
import net.endil.farmersutils.client.gui.screens.inventory.CrateScreen;
import net.endil.farmersutils.common.world.inventory.CrateMenu;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.Nullable;

public class CrateProperties
implements IGuiProperties {
    private final Class<? extends Screen> screenClass;
    private final int guiLeft;
    private final int guiTop;
    private final int guiXSize;
    private final int guiYSize;
    private final int screenWidth;
    private final int screenHeight;

    public CrateProperties(Class<? extends Screen> screenClass, int guiLeft, int guiTop, int guiXSize, int guiYSize, int screenWidth, int screenHeight) {
        Preconditions.checkArgument((guiXSize > 0 ? 1 : 0) != 0, (Object)"guiXSize must be > 0");
        Preconditions.checkArgument((guiYSize > 0 ? 1 : 0) != 0, (Object)"guiYSize must be > 0");
        Preconditions.checkArgument((screenWidth > 0 ? 1 : 0) != 0, (Object)"screenWidth must be > 0");
        Preconditions.checkArgument((screenHeight > 0 ? 1 : 0) != 0, (Object)"screenHeight must be > 0");
        this.screenClass = screenClass;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Nullable
    public static CrateProperties create(AbstractContainerScreen<CrateMenu> containerScreen) {
        if (containerScreen.f_96543_ <= 0 || containerScreen.f_96544_ <= 0) {
            return null;
        }
        return new CrateProperties(containerScreen.getClass(), containerScreen.getGuiLeft(), containerScreen.getGuiTop(), containerScreen.getXSize(), containerScreen.getYSize(), containerScreen.f_96543_, containerScreen.f_96544_);
    }

    public Class<? extends Screen> getScreenClass() {
        return CrateScreen.class;
    }

    public int getGuiLeft() {
        return (this.screenWidth - 230) / 2;
    }

    public int getGuiTop() {
        return (this.screenHeight - 222) / 2;
    }

    public int getGuiXSize() {
        return 230;
    }

    public int getGuiYSize() {
        return 222;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }
}

